/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.unascribed.ears.NativeImageAdapter;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsCommon;
import com.unascribed.ears.common.EarsFeaturesHolder;
import com.unascribed.ears.common.EarsFeaturesParser;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.render.AbstractEarsRenderDelegate;
import com.unascribed.ears.common.util.EarsStorage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HttpTexture.class})
public abstract class MixinHttpTexture
extends SimpleTexture
implements EarsFeaturesHolder {
    private EarsFeatures earsFeatures;
    private static boolean ears$reentering;

    public MixinHttpTexture(ResourceLocation location) {
        super(location);
    }

    @Inject(at={@At(value="RETURN")}, method={"load(Ljava/io/InputStream;)Lcom/mojang/blaze3d/platform/NativeImage;"})
    private void load(InputStream stream, CallbackInfoReturnable<NativeImage> ci) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "Process player skin");
        NativeImage cur = (NativeImage)ci.getReturnValue();
        if (cur != null) {
            this.earsFeatures = EarsFeaturesParser.detect(new NativeImageAdapter(cur), EarsStorage.get(cur, EarsStorage.Key.ALFALFA), data -> new NativeImageAdapter(NativeImage.m_85062_((ByteBuffer)AbstractEarsRenderDelegate.toNativeBuffer(data))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"setNoAlpha(Lcom/mojang/blaze3d/platform/NativeImage;IIII)V"}, cancellable=true)
    private static void setNoAlpha(NativeImage image, int x1, int y1, int x2, int y2, CallbackInfo ci) {
        EarsLog.debug(EarsLog.Tag.PLATFORM_INJECT, "stripAlpha({}, {}, {}, {}, {}) reentering={}", (Object)image, x1, y2, x2, y2, ears$reentering);
        if (ears$reentering) {
            return;
        }
        if (x1 == 0 && y1 == 0 && x2 == 32 && y2 == 16) {
            try {
                ears$reentering = true;
                EarsStorage.put(image, EarsStorage.Key.ALFALFA, EarsCommon.preprocessSkin(new NativeImageAdapter(image)));
                EarsCommon.carefullyStripAlpha((_x1, _y1, _x2, _y2) -> MixinHttpTexture.m_118022_(image, _x1, _y1, _x2, _y2), image.m_85084_() != 32);
            }
            finally {
                ears$reentering = false;
            }
        }
        ci.cancel();
    }

    @Shadow
    private static void m_118022_(NativeImage image, int x1, int y1, int x2, int y2) {
    }

    @Override
    public EarsFeatures getEarsFeatures() {
        return this.earsFeatures;
    }
}

